<?

/*
 * iCalendar/CSV (et al) interface to SyncML
 *
 * (c) 2005 Jeremy Laidman, AnswerZ Pty Ltd
 *
 * See the copyright file for licensing information.
 *
 */

/* Version 0.2 */

/* Todo:
	- sort out authentication, at present anyone can view another's cal
	- expose private records for record owner (currently obscured for all)
 */

$debug=0;
if ($debug) {
	header ("Content-Type: text/plain");
}

include_once "config.php";

$request=$_SERVER['PHP_SELF'];
# append "/bla.ics" to get a CSV file for user bla, and so on
$extension="";
$showuser="";
$command="";
if (strchr($request,"/")!==false) {
	if (strcasecmp(substr($request,-4,1),".")==0) {
		$request=substr(strrchr($request,"/"),1);
		$extension=substr($request,-3);
		$showuser=substr($request,0,strlen($request)-4);
	} else {
		$command=substr(strrchr($request,"/"),1);
	}
}
if (strcasecmp($extension,"PHP")==0) {
	$request="";
	$extension="";
	$showuser="";
}

//if (@$_SERVER["CONTENT_TYPE"] != "application/moo.cow") { 
//    $stderr=fopen('php://stderr','w');
//    
//    fwrite($stderr,"content type is ".@$_SERVER["CONTENT_TYPE"]."\n");
//    fclose($stderr);
//    //exit();
//}

$user=$_SERVER["PHP_AUTH_USER"];
$pass=$_SERVER["PHP_AUTH_PW"];
$querystring=$_SERVER["QUERY_STRING"];
$bypasssecurity=0;
$remaddr=$_SERVER["REMOTE_ADDR"];
if ($remaddr == "127.0.0.1" or $remaddr == "203.16.208.226") {
	$bypasssecurity=1;
}
if (!$user and !bypasssecurity) {
	// If empty, send header causing dialog box to appear
	header('WWW-Authenticate: Basic realm="SyncML"');
	header('HTTP/1.0 401 Unauthorized');
	echo "Authorization Required.\n";
	exit;
}

$summarysearch="";
$startsearch="";
$endsearch="";
if ($querystring) {
	$queries=explode("&",$querystring);
	foreach($queries as $query) {
		if ($debug) {
			echo "[$query]\n";
		}
		$bits=explode("=",$query);
		if (strcasecmp($bits[0],"summary")==0) {
			$summarysearch=$bits[1];
		} elseif (strcasecmp($bits[0],"start")) {
			$startsearch=$bits[1];
		} elseif (strcasecmp($bits[0],"end")) {
			$endsearch=$bits[1];
		}
	}
}

if ($debug) {
	echo "user: $user\n";
	echo "showuser: $showuser\n";
	echo "request: $request\n";
	echo "extension: $extension\n";
	echo "querystring: $querystring\n";
	echo "command: $command\n";
	echo "summarysearch: $summarysearch\n";
	echo "remotehost: $remaddr\n";
	#echo "bypasssecurity: $bypasssecurity\n";
	echo "--\n";
}

$db = mysql_pconnect($db_server, $db_username, $db_password, $db_name);
mysql_select_db($db_name);

if (strlen($command) > 0 and strcasecmp($command,"LIST")!==false) {
	# list the calendars (users)
	if (!$bypasssecurity) {
		$q = mysql_query (sprintf('SELECT user_id from users where name = "%s" and password = "%s"',$user,$pass),$db);
		if (mysql_num_rows($q) == 0) {
		//	header('WWW-Authenticate: Basic realm="SyncML"');
		//	header('HTTP/1.0 401 Unauthorized');
			header ("Content-Type: text/plain");
			header ("Accept-Charset: UTF-8");
			echo "No such user: $user\n";
			exit();
		}
	}

	$q = mysql_query ('SELECT name from users',$db);
	if (mysql_num_rows($q) == 0) {
		echo "No users\n";
		exit();
	}

	while ($row=mysql_fetch_array($q)) {
		echo $row[0]."\n";
	}

	exit();
}

if (strlen($showuser)==0 or $showuser == $user or $showuser=="self") {
	$q = mysql_query (sprintf('SELECT user_id from users where name = "%s" and password = "%s"',$user,$pass),$db);
	if (mysql_num_rows($q) == 0) {
	//	header('WWW-Authenticate: Basic realm="SyncML"');
	//	header('HTTP/1.0 401 Unauthorized');
		header ("Content-Type: text/plain");
		header ("Accept-Charset: UTF-8");
		echo "No such user: $user\n";
		exit();
	}

	$row=mysql_fetch_array($q);
	$userid=$row[0];
	$q = mysql_query (sprintf('SELECT vcalendar from vcalendars where user_id = %d',$userid),$db);

	if (mysql_num_rows($q) == 0) {
		echo "Empty vcalendar for userID $userid/$user\n";
		exit();
	}
} elseif (strcasecmp($showuser,"all") == 0) {
	$q = mysql_query (sprintf('SELECT user_id from users where name = "%s" and password = "%s"',$user,$pass),$db);
	if (mysql_num_rows($q) == 0) {
	//	header('WWW-Authenticate: Basic realm="SyncML"');
	//	header('HTTP/1.0 401 Unauthorized');
		header ("Content-Type: text/plain");
		header ("Accept-Charset: UTF-8");
		echo "Authentication failed for user $user\n";
		exit();
	}

	$row=mysql_fetch_array($q);
	$userid=$row[0];
	$q = mysql_query ('SELECT vcalendar from vcalendars',$db);

	if (mysql_num_rows($q) == 0) {
		echo "No vcalendars!\n";
		exit();
	}
} else {
	# asking for details on another user
	if (!$bypasssecurity) {
		$q = mysql_query (sprintf('SELECT user_id from users where name = "%s" and password = "%s"',$user,$pass),$db);
		if (mysql_num_rows($q) == 0) {
		//	header('WWW-Authenticate: Basic realm="SyncML"');
		//	header('HTTP/1.0 401 Unauthorized');
			header ("Content-Type: text/plain");
			header ("Accept-Charset: UTF-8");
			echo "No such user: $user\n";
			exit();
		}
	}

	$q = mysql_query (sprintf('SELECT user_id from users where name = "%s"',$showuser),$db);
	if (mysql_num_rows($q) == 0) {
		echo "No such user: $showuser\n";
		exit();
	}

	$row=mysql_fetch_array($q);
	$userid=$row[0];
	$q = mysql_query (sprintf('SELECT vcalendar from vcalendars where user_id = %d',$userid),$db);

	if (mysql_num_rows($q) == 0) {
		echo "Empty vcalendar for userID $userid/$user\n";
		exit();
	}
}

if ($extension == "ics" or $extension=="") {
	header ("Content-Type: text/plain");
	header ("Accept-Charset: UTF-8");
	do_ics($q,$summarysearch);
} elseif ($extension == "csv") {
	#header ("Content-Type: application/x-excel");
	header ("Content-Type: text/plain");
	header ("Accept-Charset: UTF-8");
	do_csv($q,$summarysearch);
} else {
	echo "File type \"$extension\" not understood\n";
}

function &do_ics(&$q,&$summarysearch) {
	echo "BEGIN:VCALENDAR\n";
	echo "VERSION:1.0\n";
	while ($row=mysql_fetch_array($q)) {
	  $output="";
	  $subject="";
	  $lines=explode("\n",$row[0]);
	  # don't get private items
	  if (strpos($row[0],"CLASS:PUBLIC") === false) {
	    foreach($lines as $vcalline) {
	      if (	$vcalline == "BEGIN:VEVENT" or
			$vcalline == "END:VEVENT" or
			$vcalline == "BEGIN:VTODO" or
			$vcalline == "END:VTODO" or
			strpos($vcalline,"UID:") !== false or
			strpos($vcalline,"CLASS:") !== false or
			strpos($vcalline,"DCREATED:") !== false or
			strpos($vcalline,"LAST-MODIFIED:") !== false or
			strpos($vcalline,"DTSTART:") !== false or
			strpos($vcalline,"DTEND:") !== false or
			strpos($vcalline,"RRULE:") !== false or
			false ) {
		# insert the special description just before the end tag
		if (strpos($vcalline,"END:") !== false) {
		  $output=$output."SUMMARY:PRIVATE\n";
		}
		$output=$output.$vcalline."\n";
	      }
	      $pos=strstr($vcalline,"SUMMARY:");
	      if ($pos !== false and $pos == 0) {
		  $summary=substr($vcalline,strpos($vcalline,":")+1);
	      }
	    }
	  } else {
	    foreach($lines as $vcalline) {
	      if (	$vcalline != "BEGIN:VCALENDAR" and
			$vcalline != "END:VCALENDAR" and
			$vcalline != "VERSION:1.0" and
			$vcalline != "") {
		$output=$output.$vcalline."\n";
	      }
	      $pos=strstr($vcalline,"SUMMARY:");
	      if ($pos !== false and $pos == 0) {
		  $summary=substr($vcalline,strpos($vcalline,":")+1);
	      }
	    }
	  }
	  if (strlen($summarysearch)==0 or
			preg_match("/".$summarysearch."/i",$summary)) {
		echo "$output";
	  }
	}
	echo "END:VCALENDAR\n";
}

function &do_csv(&$q,&$summarysearch) {
	while ($row=mysql_fetch_array($q)) {
	  $lines=explode("\n",$row[0]);
	  # don't get private items
	  $type="";
	  $summary="";
	  $dtstart="";
	  $dtend="";
	  $location="";
	  $priority="";
	  foreach($lines as $vcalline) {
		if (strpos($vcalline,"SUMMARY:") !== false) {
			if (strpos($row[0],"CLASS:PUBLIC") === false) {
				$summary="PRIVATE";
			} else {
				$summary=substr($vcalline,strpos($vcalline,":")+1);
			}
		} elseif (strpos($vcalline,"DTSTART:") !== false) {
			$dtstart=substr($vcalline,strpos($vcalline,":")+1);
		} elseif (strpos($vcalline,"DTEND:") !== false) {
			$dtend=substr($vcalline,strpos($vcalline,":")+1);
		} elseif (strpos($vcalline,"BEGIN:") !== false) {
			$type=substr($vcalline,strpos($vcalline,":")+1);
		}
	  }
	  # only show events
	  if ($type == "VEVENT") {
		if (strlen($summarysearch)==0 or
			preg_match("/".$summarysearch."/i",$summary)) {
				echo "\"$summary\",$dtstart,$dtend\n";
		}
	  }
	}
}

?>
